/*
 * Decompiled with CFR 0.152.
 */
package com.github.monun.survival.tap.event;

import com.github.monun.survival.tap.event.DefaultProvider;
import com.github.monun.survival.tap.event.EntityProvider;
import com.github.monun.survival.tap.event.EventEntityProvider;
import com.github.monun.survival.tap.event.EventTools;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.event.Event;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\u00020\u00062\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0007J\u0018\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0007J\u0014\u0010\u000e\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0007J\u0018\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00052\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0007R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/github/monun/survival/tap/event/EventTools;", "", "()V", "CUSTOM_PROVIDERS", "Ljava/util/WeakHashMap;", "Ljava/lang/Class;", "Lcom/github/monun/survival/tap/event/EventEntityProvider;", "DEFAULT_PROVIDERS", "", "[Lcom/github/monun/survival/tap/event/EventEntityProvider;", "findDefaultProvider", "eventClass", "getGenericEventType", "providerClass", "getOrCreateCustomProvide", "getRegistrationClass", "clazz", "api"})
public final class EventTools {
    private static final WeakHashMap<Class<?>, EventEntityProvider> CUSTOM_PROVIDERS;
    private static final EventEntityProvider[] DEFAULT_PROVIDERS;
    @NotNull
    public static final EventTools INSTANCE;

    @JvmStatic
    @NotNull
    public static final Class<?> getRegistrationClass(@NotNull Class<?> clazz) {
        Class<?> clazz2;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            clazz.getDeclaredMethod("getHandlerList", new Class[0]);
            clazz2 = clazz;
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() == null || !(Intrinsics.areEqual(clazz.getSuperclass(), Event.class) ^ true) || !Event.class.isAssignableFrom(clazz.getSuperclass())) {
                throw (Throwable)new IllegalPluginAccessException("Unable to find handler list for event " + clazz.getName() + ". Static getHandlerList method required!");
            }
            Class<Event> clazz3 = clazz.getSuperclass().asSubclass(Event.class);
            Intrinsics.checkNotNullExpressionValue(clazz3, (String)"clazz.superclass.asSubclass(Event::class.java)");
            clazz2 = EventTools.getRegistrationClass(clazz3);
        }
        return clazz2;
    }

    @JvmStatic
    @NotNull
    public static final EventEntityProvider findDefaultProvider(@NotNull Class<?> eventClass) {
        Intrinsics.checkNotNullParameter(eventClass, (String)"eventClass");
        for (EventEntityProvider provider : DEFAULT_PROVIDERS) {
            if (!provider.getEventClass().isAssignableFrom(eventClass)) continue;
            return provider;
        }
        throw (Throwable)new IllegalArgumentException("Not found DefaultProvider for " + eventClass);
    }

    @JvmStatic
    @NotNull
    public static final EventEntityProvider getOrCreateCustomProvide(@NotNull Class<?> providerClass) {
        Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
        Object v = CUSTOM_PROVIDERS.computeIfAbsent(providerClass, getOrCreateCustomProvide.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(v, (String)"CUSTOM_PROVIDERS.compute\u2026)\n            }\n        }");
        return (EventEntityProvider)v;
    }

    @JvmStatic
    @NotNull
    public static final Class<?> getGenericEventType(@NotNull Class<?> providerClass) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
        Class<?> clazz2 = providerClass;
        String prefix = EntityProvider.class.getName() + "<";
        Type[] genericInterfaces = clazz2.getGenericInterfaces();
        do {
            int n;
            Type[] typeArray = genericInterfaces;
            int n2 = typeArray.length;
            for (n = 0; n < n2; ++n) {
                Type genericInterface;
                Type type = genericInterface = typeArray[n];
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"genericInterface");
                String string2 = type.getTypeName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"genericInterface.typeName");
                if (!StringsKt.startsWith$default((String)string2, (String)prefix, (boolean)false, (int)2, null)) continue;
                Type type2 = ((ParameterizedType)genericInterface).getActualTypeArguments()[0];
                if (type2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
                }
                return (Class)type2;
            }
            clazz = clazz2.getSuperclass();
            n = 0;
            boolean bl = false;
            Class<?> it = clazz;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(it, (String)"it");
        } while (Intrinsics.areEqual(clazz, Object.class) ^ true);
        throw (Throwable)new IllegalArgumentException(clazz2 + " is not EntityProvider");
    }

    private EventTools() {
    }

    static {
        EventTools eventTools;
        INSTANCE = eventTools = new EventTools();
        CUSTOM_PROVIDERS = new WeakHashMap();
        Class<?>[] classes = DefaultProvider.class.getDeclaredClasses();
        ArrayList<EventEntityProvider> defaultProviders = new ArrayList<EventEntityProvider>(classes.length);
        for (Class<?> clazz : classes) {
            if (!EntityProvider.class.isAssignableFrom(clazz)) continue;
            try {
                Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (obj == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.github.monun.tap.event.EntityProvider<org.bukkit.event.Event>");
                }
                defaultProviders.add(new EventEntityProvider((EntityProvider)obj));
            }
            catch (Exception e) {
                throw (Throwable)((Object)new AssertionError((Object)e));
            }
        }
        Collection $this$toTypedArray$iv = defaultProviders;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        EventEntityProvider[] eventEntityProviderArray = thisCollection$iv.toArray(new EventEntityProvider[0]);
        if (eventEntityProviderArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        DEFAULT_PROVIDERS = eventEntityProviderArray;
    }
}

